/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client;

import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietResult;
import com.illusivesoulworks.diet.client.DietKeys;
import com.illusivesoulworks.diet.client.screen.DietScreen;
import com.illusivesoulworks.diet.client.screen.DynamicButton;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.util.DietResult;
import com.illusivesoulworks.diet.platform.ClientServices;
import com.illusivesoulworks.diet.platform.Services;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DietClientEvents {
    private static final TagKey<Item> SPECIAL_FOOD = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("diet", "special_food"));
    private static final DecimalFormat DECIMALFORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.#"), num -> num.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");
    public static List<Component> tooltip = null;
    public static int tooltipX = 0;
    public static int tooltipY = 0;

    public static void tick(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (player != null && mc.m_91302_() && !(mc.f_91080_ instanceof DietScreen) && DietKeys.OPEN_GUI.m_90859_()) {
            mc.m_91152_((Screen)new DietScreen(mc.f_91080_ instanceof InventoryScreen));
        }
    }

    public static DynamicButton getButton(Screen screen) {
        if (((Boolean)DietConfig.CLIENT.addButton.get()).booleanValue()) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            return new DynamicButton(containerScreen, ClientServices.INSTANCE.getGuiLeft(containerScreen) + (Integer)DietConfig.CLIENT.buttonX.get(), containerScreen.f_96544_ / 2 + (Integer)DietConfig.CLIENT.buttonY.get(), 20, 18, 0, 0, 19, ICONS, button -> Minecraft.m_91087_().m_91152_((Screen)new DietScreen(true)));
        }
        return null;
    }

    public static void renderTooltip(Minecraft mc) {
        if (tooltip != null) {
            Screen screen = mc.f_91080_;
            if (screen != null) {
                screen.m_169388_(new PoseStack(), tooltip, Optional.empty(), tooltipX, tooltipY);
            }
            tooltip = null;
        }
    }

    public static void renderItemTooltip(Player player, ItemStack stack, List<Component> tooltips) {
        if (player != null) {
            if (((Boolean)DietConfig.SERVER.hideTooltipsUntilEaten.get()).booleanValue() && Services.CAPABILITY.get(player).map(tracker -> !tracker.getEaten().contains(stack.m_41720_())).orElse(false).booleanValue()) {
                return;
            }
            IDietResult result = DietApi.getInstance().get(player, stack);
            if (result != DietResult.EMPTY) {
                Map<IDietGroup, Float> groups = result.get();
                boolean specialFood = stack.m_204117_(SPECIAL_FOOD);
                if (!groups.isEmpty()) {
                    ArrayList groupsTooltips = new ArrayList();
                    ArrayList<MutableComponent> beneficial = new ArrayList<MutableComponent>();
                    ArrayList<MutableComponent> harmful = new ArrayList<MutableComponent>();
                    for (Map.Entry<IDietGroup, Float> entry : groups.entrySet()) {
                        float value = entry.getValue().floatValue();
                        MutableComponent groupName = Component.m_237115_((String)("groups.diet." + entry.getKey().getName() + ".name"));
                        MutableComponent tooltip = null;
                        if (specialFood) {
                            tooltip = Component.m_237110_((String)"tooltip.diet.group_", (Object[])new Object[]{groupName});
                        } else if (value > 0.0f) {
                            tooltip = Component.m_237110_((String)"tooltip.diet.group", (Object[])new Object[]{DECIMALFORMAT.format(entry.getValue().floatValue() * 100.0f), groupName});
                        }
                        if (tooltip == null) continue;
                        if (entry.getKey().isBeneficial()) {
                            tooltip.m_130940_(ChatFormatting.GREEN);
                            beneficial.add(tooltip);
                            continue;
                        }
                        tooltip.m_130940_(ChatFormatting.RED);
                        harmful.add(tooltip);
                    }
                    groupsTooltips.addAll(beneficial);
                    groupsTooltips.addAll(harmful);
                    if (!groupsTooltips.isEmpty()) {
                        tooltips.add((Component)Component.m_237119_());
                        tooltips.add((Component)Component.m_237115_((String)"tooltip.diet.eaten").m_130940_(ChatFormatting.GRAY));
                        tooltips.addAll(groupsTooltips);
                    }
                }
            }
        }
    }
}

